/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.world.entity.projectile;

import com.dfdyz.epicacg.registry.Entities;
import com.dfdyz.epicacg.utils.FireworkUtils;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class YoimiyaSAArrow
extends Arrow {
    protected float dmg = 15.0f;
    protected float expRadio = 2.0f;
    protected boolean shouldDestroy = false;

    public YoimiyaSAArrow(EntityType<? extends Arrow> type, Level level) {
        super(type, level);
        this.m_7311_(0);
    }

    public YoimiyaSAArrow(Level level, Vec3 pos, Entity owner) {
        super((EntityType)Entities.GS_YoimiyaSA_ARROW.get(), level);
        this.m_146884_(pos);
        this.m_5602_(owner);
        this.m_7311_(0);
    }

    public YoimiyaSAArrow(Level level, double x, double y, double z) {
        super((EntityType)Entities.GS_YoimiyaSA_ARROW.get(), level);
        this.m_6034_(x, y, z);
        this.m_7311_(0);
    }

    public YoimiyaSAArrow(Level level, double x, double y, double z, float dmg) {
        super((EntityType)Entities.GS_YoimiyaSA_ARROW.get(), level);
        this.m_6034_(x, y, z);
        this.dmg = dmg;
        this.m_7311_(0);
    }

    public void setExpRadio(float r) {
        this.expRadio = r;
    }

    public void m_8119_() {
        if (this.shouldDestroy) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    public void m_6686_(double p_37266_, double p_37267_, double p_37268_, float p_37269_, float p_37270_) {
        super.m_6686_(p_37266_, p_37267_, p_37268_, p_37269_, p_37270_);
        this.m_20095_();
    }

    public void setDmg(float dmg) {
        this.dmg = dmg;
    }

    public void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            Vec3 ExpBox = new Vec3((double)this.expRadio, (double)this.expRadio, (double)this.expRadio);
            Vec3 hitPos = hitResult.m_82450_();
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7228_(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 1.0, 1.0, 1.0, FireworkUtils.Explode);
                this.m_9236_().m_7785_(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
            }
            List list = this.m_9236_().m_45933_((Entity)this, new AABB(hitPos.m_82546_(ExpBox), hitPos.m_82549_(ExpBox)));
            Entity owner = this.m_19749_();
            for (Entity e : list) {
                if (e.equals((Object)owner) || e.m_6128_() || !(e.m_20270_((Entity)this) <= this.expRadio)) continue;
                e.m_6469_(this.GetDamageSource(), this.dmg);
            }
            this.shouldDestroy = true;
        }
    }

    protected DamageSource GetDamageSource() {
        DamageSource damagesource;
        DamageSources damageSources = this.m_9236_().m_269111_();
        Entity owner = this.m_19749_();
        if (owner instanceof Player) {
            Player player = (Player)owner;
            damagesource = damageSources.m_269075_(player);
        } else if (owner instanceof Mob) {
            Mob mob = (Mob)owner;
            damagesource = damageSources.m_269333_((LivingEntity)mob);
        } else {
            damagesource = damageSources.m_269418_((AbstractArrow)this, owner);
        }
        return damagesource;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("Dmg", this.dmg);
        compoundTag.m_128350_("ExpRadio", this.expRadio);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.dmg = compoundTag.m_128457_("Dmg");
        this.expRadio = compoundTag.m_128457_("ExpRadio");
    }
}

